package com.oledcommlifi.campusipwebdemo;

import oledcomm.android.lifi.GeoAudioAnalysis;
import oledcomm.android.lifi.JackStatus;
import oledcomm.android.lifi.LiFiLocation;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebSettings.PluginState;
import android.webkit.WebSettings.RenderPriority;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;

import com.oledcommlifi.campusipwebdemo.R;

/*
 * Copyright (c) 2014,OLEDCOMM
 * All rights reserved.
 *
 * File nameCampusIPActivity.java
 * Abstract: Web application for CampusIP with two LiFi lamps
 *
 * Version1.0
 * Author: DENG Nan
 * Date: 14 May 2014
 *
 */

public class CampusIPActivity extends Activity {


	boolean tag1_flag = false;
	boolean tag2_flag = false;

	GeoAudioAnalysis location;

	ImageView campusIP_front;

	WebView campusIP_web;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		campusIP_front = (ImageView) findViewById(R.id.campusIP_front);
		campusIP_web = (WebView) findViewById(R.id.campusIP_web);
		
		campusIP_front.setVisibility(View.VISIBLE);
		campusIP_front.setImageResource(R.drawable.front);
		campusIP_web.setVisibility(View.INVISIBLE);
		
		//WebView init
		campusIP_web.getSettings().setJavaScriptEnabled (true); 
		campusIP_web.getSettings().setJavaScriptCanOpenWindowsAutomatically (false);
		campusIP_web.getSettings().setPluginsEnabled (true);
		campusIP_web.getSettings().setSupportMultipleWindows (false);
		campusIP_web.getSettings().setSupportZoom (false);
		campusIP_web.setVerticalScrollBarEnabled (false);
		campusIP_web.setHorizontalScrollBarEnabled (false);
		
		campusIP_web.getSettings().setPluginState(PluginState.ON);
		campusIP_web.getSettings().setAllowFileAccess(true);

		campusIP_web.getSettings().setAppCacheMaxSize(1024 * 8);
		campusIP_web.getSettings().setAppCacheEnabled(true);

		campusIP_web.getSettings().setUseWideViewPort(false);
		campusIP_web.setWebChromeClient(new WebChromeClient());
		campusIP_web.setWebViewClient(new WebViewClient());

		// these settings speed up page load into the webview
		campusIP_web.getSettings().setRenderPriority(RenderPriority.HIGH);
		campusIP_web.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);


		// create a new GeoAudioAnalysis object, which is the LiFi receiver
		location = new GeoAudioAnalysis(jack_status, getApplicationContext());
		// start to watch the position changes
		location.watchPosition(position);

	}

	// When you press home button, the app will stop and release the resource.
	@Override
	protected void onStop() {
		super.onStop();
		location.clearPosition();
		finish();
		

	}

	// When the activity is destroyed, the position must be cleared.
	@Override
	protected void onDestroy() {
		super.onDestroy();
		location.clearPosition();
		finish();

	}

	// Screen rotates, nothing should happen
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
			// Nothing need to be done here

		} else {
			// Nothing need to be done here

		}
	}

	LiFiLocation position = new LiFiLocation() {

		@Override
		public void onLocationSuccess(String value) {
			// TODO Auto-generated method stub

			// the tag IDs are received, perform your UI operations based on this
			if ((value.split(" ")[0].equals("0x4f3c"))) {
				if (tag1_flag == false) {
					tag1_flag = true;

					campusIP_front.setVisibility(View.INVISIBLE);
					campusIP_web.setVisibility(View.VISIBLE);
					campusIP_web.loadUrl("http://fr.wikipedia.org/wiki/La_Joconde");
				}
				tag2_flag = false;

			} else if ((value.split(" ")[0].equals("0x77c4"))) {
				if (tag2_flag == false) {
					tag2_flag = true;

					campusIP_front.setVisibility(View.INVISIBLE);
					campusIP_web.setVisibility(View.VISIBLE);
					campusIP_web.loadUrl("http://fr.wikipedia.org/wiki/Les_Tournesols");

				}
				tag1_flag = false;

			}

		}

		@Override
		public void onLocationError(int error) {
			// TODO Auto-generated method stub

			// instead of getting a valid ID, the errors are received, also useful for your UI operations
			if (error == LiFiLocation.ERROR_NO_TAG) {
				// write your reaction

			} else if (error == LiFiLocation.ERROR_WRONG_FORMAT) {
				// write your reaction
			}
		}

	};

	JackStatus jack_status = new JackStatus() {

		@Override
		public void onJackEvent(int Event) {
			// TODO Auto-generated method stub

			// you can write your reactions when different JACK sensor status is
			// present

			switch (Event) {
			case JACK_PLUGGED:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor plugged",
				// Toast.LENGTH_SHORT).show();
				break;
			case JACK_UNPLUGGED:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor unplugged", Toast.LENGTH_SHORT).show();
				break;
			case JACK_ABSENCE:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor absence",
				// Toast.LENGTH_SHORT).show();
				break;
			}

		}

	};

}
